/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.BakedAnimationCache;
import software.bernie.geckolib.cache.BakedModelCache;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.loading.definition.geometry.GeometryDescription;
import software.bernie.geckolib.loading.json.ModelFormatVersion;
import software.bernie.geckolib.loading.json.raw.Bone;
import software.bernie.geckolib.loading.json.raw.Cube;
import software.bernie.geckolib.loading.json.raw.FaceUV;
import software.bernie.geckolib.loading.json.raw.LocatorClass;
import software.bernie.geckolib.loading.json.raw.LocatorValue;
import software.bernie.geckolib.loading.json.raw.MinecraftGeometry;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.json.raw.PolyMesh;
import software.bernie.geckolib.loading.json.raw.PolysUnion;
import software.bernie.geckolib.loading.json.raw.TextureMesh;
import software.bernie.geckolib.loading.json.raw.UVFaces;
import software.bernie.geckolib.loading.json.raw.UVUnion;
import software.bernie.geckolib.loading.json.typeadapter.BakedAnimationsAdapter;
import software.bernie.geckolib.loading.json.typeadapter.KeyFrameMarkersAdapter;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.object.CompoundException;

public final class GeckoLibResources {
    public static final class_2960 RELOAD_LISTENER_ID = GeckoLibConstants.id("geckolib_resources");
    public static final class_2960 ANIMATIONS_PATH = GeckoLibConstants.id("geckolib/animations");
    public static final class_2960 MODELS_PATH = GeckoLibConstants.id("geckolib/models");
    public static final Pattern SUFFIX_STRIPPER = Pattern.compile("((\\.geo)|((\\.animation)s?))?(\\.json)$");
    public static final Pattern PREFIX_STRIPPER = Pattern.compile("^(geckolib/)((animations/)|(models/))?");
    public static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(MinecraftGeometry.class, MinecraftGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(GeometryDescription.class, GeometryDescription.gsonDeserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).registerTypeAdapter(Animation.KeyframeMarkers.class, KeyFrameMarkersAdapter.deserializer()).registerTypeAdapter(BakedAnimations.class, BakedAnimationsAdapter.deserializer()).create();
    private static BakedAnimationCache ANIMATIONS = new BakedAnimationCache(Collections.emptyMap());
    private static BakedModelCache MODELS = new BakedModelCache(Collections.emptyMap());

    public static BakedAnimationCache getBakedAnimations() {
        return ANIMATIONS;
    }

    public static BakedModelCache getBakedModels() {
        return MODELS;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> reload(class_3302.class_11558 sharedState, Executor prepExecutor, class_3302.class_4045 preparationBarrier, Executor applicationExecutor) {
        CompletableFuture<Map<class_2960, BakedAnimations>> animations = GeckoLibResources.loadAnimations(prepExecutor, sharedState.method_72361());
        CompletableFuture<Map<class_2960, BakedGeoModel>> models = GeckoLibResources.loadModels(prepExecutor, sharedState.method_72361());
        return CompletableFuture.runAsync(() -> {
            BakedAnimationsAdapter.COMPRESSION_CACHE = new ConcurrentHashMap<Double, Constant>();
        }, prepExecutor).thenCompose(ignored -> ((CompletableFuture)CompletableFuture.allOf(animations, models).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenRunAsync(() -> {
            ANIMATIONS = new BakedAnimationCache((Map)animations.join());
            MODELS = new BakedModelCache((Map)models.join());
            BakedAnimationsAdapter.COMPRESSION_CACHE = null;
        }, applicationExecutor));
    }

    public static class_2960 stripPrefixAndSuffix(class_2960 path) {
        String newPath = path.method_12832();
        Matcher prefixMatcher = PREFIX_STRIPPER.matcher(newPath);
        newPath = prefixMatcher.find() ? newPath.substring(prefixMatcher.end()) : newPath;
        Matcher suffixMatcher = SUFFIX_STRIPPER.matcher(newPath);
        newPath = suffixMatcher.find() ? newPath.substring(0, suffixMatcher.start()) : newPath;
        return newPath.length() == path.method_12832().length() ? path : path.method_45136(newPath);
    }

    private static CompletableFuture<Map<class_2960, BakedAnimations>> loadAnimations(Executor backgroundExecutor, class_3300 resourceManager) {
        return GeckoLibResources.bakeJsonResources(backgroundExecutor, resourceManager, ANIMATIONS_PATH.method_12832(), GeckoLibResources::bakeAnimations, ex -> new BakedAnimations((Map<String, Animation>)new Object2ObjectOpenHashMap()));
    }

    private static CompletableFuture<Map<class_2960, BakedGeoModel>> loadModels(Executor backgroundExecutor, class_3300 resourceManager) {
        return GeckoLibResources.bakeJsonResources(backgroundExecutor, resourceManager, MODELS_PATH.method_12832(), GeckoLibResources::bakeModel, ex -> null);
    }

    private static <BAKED> CompletableFuture<Map<class_2960, BAKED>> bakeJsonResources(Executor backgroundExecutor, class_3300 resourceManager, String assetPath, BiFunction<class_2960, JsonObject, BAKED> elementFactory, Function<Throwable, @Nullable BAKED> exceptionalFactory) {
        return GeckoLibResources.loadResources(backgroundExecutor, resourceManager, assetPath, "json", GeckoLibResources::readJsonFile).thenCompose(resources -> {
            ObjectArrayList tasks = new ObjectArrayList(resources.size());
            resources.forEach(arg_0 -> GeckoLibResources.lambda$bakeJsonResources$7((List)tasks, elementFactory, backgroundExecutor, exceptionalFactory, arg_0));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> GeckoLibResources.lambda$bakeJsonResources$8((List)tasks, arg_0));
        });
    }

    private static <UNBAKED> CompletableFuture<List<Pair<class_2960, UNBAKED>>> loadResources(Executor executor, class_3300 resourceManager, String assetPath, String fileType, BiFunction<class_2960, class_3298, UNBAKED> elementFactory) {
        String fileTypeSuffix = "." + fileType;
        return CompletableFuture.supplyAsync(() -> resourceManager.method_14488(assetPath, fileName -> fileName.method_12832().endsWith(fileTypeSuffix)), executor).thenCompose(resources -> {
            ObjectArrayList tasks = new ObjectArrayList(resources.size());
            resources.forEach((arg_0, arg_1) -> GeckoLibResources.lambda$loadResources$13((List)tasks, elementFactory, executor, arg_0, arg_1));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> GeckoLibResources.lambda$loadResources$14((List)tasks, arg_0));
        });
    }

    private static BakedGeoModel bakeModel(class_2960 path, JsonObject json) {
        if (path.method_12832().endsWith(".animation.json")) {
            throw new RuntimeException("Found animation file found in models folder! '" + String.valueOf(path) + "'");
        }
        Model model = (Model)GSON.fromJson((JsonElement)json, Model.class);
        ModelFormatVersion matchedVersion = ModelFormatVersion.match(model.formatVersion());
        if (matchedVersion == null) {
            GeckoLibConstants.LOGGER.warn("{}: Unknown geo model format version: '{}'. This may not work correctly", (Object)path, (Object)model.formatVersion());
        } else if (!matchedVersion.isSupported()) {
            GeckoLibConstants.LOGGER.error("{}: Unsupported geo model format version: '{}'. {}", (Object)path, (Object)model.formatVersion(), (Object)matchedVersion.getErrorMessage());
        }
        return BakedModelFactory.getForNamespace(path.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
    }

    private static BakedAnimations bakeAnimations(class_2960 path, JsonObject json) {
        if (path.method_12832().endsWith(".geo.json")) {
            throw new RuntimeException("Found model file in animations folder! '" + String.valueOf(path) + "'");
        }
        try {
            return (BakedAnimations)GSON.fromJson((JsonElement)class_3518.method_15296((JsonObject)json, (String)"animations"), BakedAnimations.class);
        }
        catch (CompoundException ex) {
            throw ex.withMessage(String.valueOf(path) + ": Error building animations from JSON");
        }
        catch (Exception ex) {
            throw GeckoLibConstants.exception(path, "Error building animations from JSON", ex);
        }
    }

    private static JsonObject readJsonFile(class_2960 id, class_3298 resource) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resource.method_43039();
            try {
                jsonObject = class_3518.method_15255((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw GeckoLibConstants.exception(id, "Error reading JSON file", ex);
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    private static /* synthetic */ List lambda$loadResources$14(List tasks, Void ignored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).toList();
    }

    private static /* synthetic */ void lambda$loadResources$13(List tasks, BiFunction elementFactory, Executor executor, class_2960 path, class_3298 resource) {
        tasks.add(CompletableFuture.supplyAsync(() -> Pair.of((Object)path, elementFactory.apply(path, resource)), executor));
    }

    private static /* synthetic */ Map lambda$bakeJsonResources$8(List tasks, Void ignored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toMap(Pair::left, Pair::right));
    }

    private static /* synthetic */ void lambda$bakeJsonResources$7(List tasks, BiFunction elementFactory, Executor backgroundExecutor, Function exceptionalFactory, Pair pair) {
        tasks.add(CompletableFuture.supplyAsync(() -> Pair.of((Object)GeckoLibResources.stripPrefixAndSuffix((class_2960)pair.left()), elementFactory.apply((class_2960)pair.left(), (JsonObject)pair.right())), backgroundExecutor).exceptionally(ex -> {
            ex.printStackTrace();
            return Pair.of((Object)((class_2960)pair.left()), exceptionalFactory.apply(ex));
        }));
    }
}

